/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.sfp.topology;

import com.ibm.hsc.sfp.topology.NetworkTopology;
import com.ibm.hsc.sfp.topology.NetworkTopologyConstants;
import com.ibm.hsc.sfp.topology.NetworkTopologyNode;
import com.ibm.hwmca.fw.util.CommonXMLParser;
import com.ibm.hwmca.fw.util.MalformedXMLException;
import com.ibm.hwmca.fw.util.Trace;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;

public class NetworkTopologyParser
extends CommonXMLParser
implements NetworkTopologyConstants {
    private static final String TRACE_MASKT = "JSNTOPOT";
    private static final String TRACE_MASKF = "JSNTOPOF";
    private static final String TRACE_MASKD = "JSNTOPOD";

    private NetworkTopologyParser() throws SAXNotRecognizedException, SAXNotSupportedException {
        Trace.trace((String)TRACE_MASKT, (Object)"<>NetworkTopologyParser.c-tor");
    }

    static void parseXML(File file, NetworkTopology networkTopology) throws MalformedXMLException {
        Trace.trace((String)TRACE_MASKT, (Object)("-> NetworkTopologyParser.parseXML(" + file + ")"));
        try {
            NetworkTopologyParser networkTopologyParser = new NetworkTopologyParser();
            networkTopologyParser.parse(new InputSource(new FileInputStream(file)));
            Document document = networkTopologyParser.getDocument();
            NodeList nodeList = document.getElementsByTagName("local_hmc");
            if (nodeList.getLength() != 1) {
                throw new MalformedXMLException("A single <local_hmc> is expected.");
            }
            NetworkTopologyNode networkTopologyNode = new NetworkTopologyNode("local_hmc");
            networkTopology.setRoot(networkTopologyNode);
            NetworkTopologyParser.parseNetworkTopology(nodeList.item(0), networkTopologyNode);
        }
        catch (IOException iOException) {
            throw new MalformedXMLException("IOException reading file");
        }
        catch (SAXParseException sAXParseException) {
            throw new MalformedXMLException("SaxParseException!: " + CommonXMLParser.where((SAXParseException)sAXParseException));
        }
        catch (SAXException sAXException) {
            throw new MalformedXMLException("SaxException!: " + sAXException);
        }
        Trace.trace((String)TRACE_MASKT, (Object)("<- NetworkTopologyParser.parseXML(" + file + ")"));
    }

    private static void parseNetworkTopology(Node node, NetworkTopologyNode networkTopologyNode) {
        int n;
        Trace.trace((String)TRACE_MASKD, (Object)("NetworkTopologyParser.parseNetworkTopology() parsing element " + networkTopologyNode.getElementName()));
        NamedNodeMap namedNodeMap = node.getAttributes();
        if (namedNodeMap != null) {
            int n2 = namedNodeMap.getLength();
            for (n = 0; n < n2; ++n) {
                Node node2 = namedNodeMap.item(n);
                if (node2 == null) continue;
                networkTopologyNode.setAttribute(node2.getNodeName(), node2.getNodeValue());
            }
        }
        NodeList nodeList = node.getChildNodes();
        n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Node node3 = nodeList.item(i);
            if (node3.getNodeType() != 1) continue;
            String string = node3.getNodeName();
            NetworkTopologyNode networkTopologyNode2 = new NetworkTopologyNode(string);
            networkTopologyNode.addChild(networkTopologyNode2);
            NetworkTopologyParser.parseNetworkTopology(node3, networkTopologyNode2);
        }
    }
}

